/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.client;

import com.ibm.hsc.cim.client.HSCCECCIMClient;
import com.ibm.hsc.cim.client.HSCCIMClient;
import com.ibm.hsc.cim.client.HSCProfileCIMClient;
import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCLPARClient;
import com.ibm.hsc.client.rmc.HSCRMCClient;
import com.ibm.hsc.client.rmc.HSCRMCClientFactory;
import com.ibm.hsc.client.rmc.HSCRMCException;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.HSCExceptionUtils;
import com.ibm.hsc.common.exceptions.HSCRecoveryException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscUtil;
import com.ibm.websm.diagnostics.IDebug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class HSCLPARCIMClient
extends HSCCIMClient
implements HSCLPARClient {
    private static final String DLPAR_BUNDLE_NAME = "DLPARBundle";
    private static final String HSC_COMMON_BUNDLE_NAME = "HSCCommonBundle";
    private static final String REQUIRED_VALUE = "R";
    private static final int RC_SUCCESS = 0;
    protected static final String MOF_CPU_LPAR_TASK = "CPULPARTask";
    protected static final String MOF_CPU_QUANTITY = "CPUQuantity";
    protected static final String MOF_DEST_SLOT_ID = "DestinationSlotID";
    protected static final String MOF_DLPAR_CAPABILITIES = "DLPARCapabilities";
    protected static final String MOF_DRAWER_ID = "DrawerID";
    protected static final String MOF_IO_LPAR_TASK = "IOLPARTask";
    protected static final String MOF_IS_ROLLBACK = "IsRollback";
    protected static final String MOF_MEM_LPAR_TASK = "MemLPARTask";
    protected static final String MOF_LMB_QUANTITY = "LMBQuantity";
    protected static final String MOF_OP_PANEL_VALUE = "OpPanelValue";
    protected static final String MOF_OS_LEVEL = "OSLevel";
    protected static final String MOF_OS_TYPE = "OSType";
    protected static final String MOF_PARTITION_STATE = "PartitionState";
    protected static final String MOF_PARTITION_TYPE = "PartitionType";
    protected static final String MOF_PHYS_LOC_CODE = "PhysLocCode";
    protected static final String MOF_PCI_BUS = "PCIBus";
    protected static final String MOF_SLOT_ID = "SlotID";
    protected static final String MOF_SERVICE_AUTHORITY = "ServiceAuthority";
    protected static final String MOF_SHUTDOWN_OS = "ShutdownOS";
    protected static final String MOF_SHUTDOWN_OS_FORCE_OPTION = "forceOption";
    protected static final String MOF_SHUTDOWN_OS_REBOOT_OPTION = "rebootOption";
    protected static final String ERR_SLOT_REQUIRED = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_SLOT_REQUIRED", "The I/O slot is required. It cannot be moved or removed.");
    protected static final String ERR_SLOT_NOT_STOPPED = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_SLOT_NOT_STOPPED", "The I/O slot with an invalid state or status.");
    protected static final String ERR_SLOT_SAME_GROUP = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_SLOT_SAME_GROUP", "There is a I/O slot in the same group has a invalid state or status.");
    protected static final String ERR_SLOT_SRC_PAR = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_SLOT_SRC_PAR", "The slot doesn't belong to the source logical partition.");
    protected static final String ERR_SLOT_OP_FAILED = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_SLOT_OP_FAILED", "The actual HMC DLPAR operation failed with exception.");
    protected static final String ERR_SLOT_NOT_MATCH = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_SLOT_NOT_MATCH", "The given slot id and drawer id doesn't match.");
    protected static final String ERR_SLOT_HMC = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_SLOT_HMC", "HMCERRV3DLPAR021: HMC I/O slot DLPAR operation failed without throwing exception. Here is the failed I/O DrawerID/SlotID and the failed reason list:\n");
    protected static final String ERR_OUT_OF_SYNC = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_OUT_OF_SYNC", "The above HMC DLPAR operation failure may cause the data in HMC and AIX out of sync. If that happens, you may need to reboot the logical partition.\n");
    protected static final String INFO_HMC_ROLLBACK_SUCC = HSCResourceBundleUtil.getMessage("DLPARBundle", "INFO_HMC_ROLLBACK_SUCC", "HMC rollback operation finished successfully.\n");
    protected static final String INFO_CPU_RES = HSCResourceBundleUtil.getMessage("DLPARBundle", "INFO_CPU_RES", "processor");
    protected static final String INFO_MEM_RES = HSCResourceBundleUtil.getMessage("DLPARBundle", "INFO_MEM_RES", "memory");
    protected static final String INFO_SLOT_RES = HSCResourceBundleUtil.getMessage("DLPARBundle", "INFO_SLOT_RES", "I/O slot");
    protected static final String ERR_CPU_HMC = "HMC processor DLPAR operation failed without throwing exception. There is no enough none disabled processors to perform the operation. The request processor number is {0}, the success number is {1}.\n";
    protected static final String ERR_HMC_EXCEPTION = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_HMC_EXCEPTION", "HMCERRV3DLPAR022: HMC DLPAR operation failed with throwing an exception. The data in HMC and AIX may out of sync. If that happens, you may need to reboot the logical partition.");
    protected static final String INFO_ADD_AIX = "AIX adding {0} ......\n";
    protected static final String INFO_REMOVE_AIX = "AIX removing {0} .....\n";
    protected static final String INFO_ADD_HMC = "HMC adding {0} ......\n";
    protected static final String INFO_REMOVE_HMC = "HMC removing {0} ......\n";
    protected static final String INFO_MOVE_HMC = "HMC moving {0} ......\n";
    protected static final String INFO_HMC_ROLLBACK_ADD = "HMC rollback after AIX failed on adding {0} ......\n";
    protected static final String INFO_HMC_ROLLBACK_REMOVE = "HMC rollback after AIX failed on removing {0} .....\n";
    protected static final String INFO_ADD_AIX_SUCC = "AIX adding {0} operation finished successfully.\n";
    protected static final String INFO_REMOVE_AIX_SUCC = "AIX removing {0} operation finished successfully.\n";
    protected static final String INFO_ADD_HMC_SUCC = "HMC adding {0} operation finished successfully.\n";
    protected static final String INFO_REMOVE_HMC_SUCC = "HMC removing {0} operation finished successfully.\n";
    protected static final String INFO_MOVE_HMC_SUCC = "HMC moving {0} operation finished successfully\n";
    protected static final String SHUTDOWN_OS_OK = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OK", "Ok");
    protected static final String SHUTDOWN_OS_ERROR = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ERROR", "Error");
    protected HSCRMCClient mRMCClient = null;

    public static HSCLPARCIMClient createInstance(String string, String string2, String string3, boolean bl) throws HSCException {
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath cIMObjectPath2 = null;
        String string4 = null;
        try {
            HSCCECCIMClient hSCCECCIMClient = HSCCECCIMClient.createInstance(string, string2, bl);
            if (hSCCECCIMClient == null) {
                return null;
            }
            Enumeration enumeration = hSCCECCIMClient.getPartitionObjectPathes();
            while (enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                CIMValue cIMValue = HscUtil.getCIMAttribute(string, cIMObjectPath3, "Name");
                string4 = (String)cIMValue.getValue();
                if (string3.equals(string4)) {
                    cIMObjectPath2 = cIMObjectPath3;
                    if (bl) break;
                }
                if (bl || !string3.equals((String)(cIMValue = HscUtil.getCIMAttribute(string, cIMObjectPath3, "UserDefinedName")).getValue())) continue;
                cIMObjectPath = cIMObjectPath3;
                break;
            }
            if (cIMObjectPath == null && cIMObjectPath2 == null) {
                return null;
            }
            if (cIMObjectPath == null) {
                string4 = string3;
            } else {
                cIMObjectPath2 = cIMObjectPath;
            }
            return new HSCLPARCIMClient(string, hSCCECCIMClient, string4, cIMObjectPath2);
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public HSCLPARCIMClient(String string, HSCCECCIMClient hSCCECCIMClient, String string2, CIMObjectPath cIMObjectPath) throws HSCException {
        super(string, hSCCECCIMClient, string2, cIMObjectPath);
        CIMValue cIMValue;
        HSCRMCClientFactory hSCRMCClientFactory = HSCRMCClientFactory.getInstance(hSCCECCIMClient.getIntName());
        this.mRMCClient = hSCRMCClientFactory.createRMCClient(string2);
        if (null == string2) {
            try {
                cIMValue = HscUtil.getCIMAttribute(this.mHostName, this.mObjectPath, "Name");
                this.mIntName = (String)cIMValue.getValue();
            }
            catch (CIMException cIMException) {
                throw new HSCException(cIMException);
            }
        }
        try {
            cIMValue = HscUtil.getCIMAttribute(this.mHostName, this.mObjectPath, "UserDefinedName");
            this.mUserDefinedName = (String)cIMValue.getValue();
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public Vector getProfileNames() throws HSCException {
        CIMInstance cIMInstance = null;
        CIMProperty cIMProperty = null;
        Object var3_3 = null;
        Enumeration enumeration = null;
        String string = null;
        Vector<String> vector = new Vector<String>();
        try {
            enumeration = HscUtil.getCIMAssociationInst(this.mHostName, this.mObjectPath, "IBMHSC_PartitionProfile", "IBMHSC_LparProfile", "Element", "Setting", true, false, null);
            while (enumeration.hasMoreElements()) {
                cIMInstance = (CIMInstance)enumeration.nextElement();
                cIMProperty = cIMInstance.getProperty("UserDefinedName");
                string = (String)cIMProperty.getValue().getValue();
                if (null == string) continue;
                vector.add(string);
            }
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
        return vector;
    }

    public int getPartitionState() throws HSCException {
        CIMValue cIMValue = null;
        int n = -1;
        try {
            cIMValue = HscUtil.getCIMAttribute(this.mHostName, this.mObjectPath, MOF_PARTITION_STATE);
            n = Integer.parseInt((String)cIMValue.getValue());
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
        return n;
    }

    public int getPartitionType() throws HSCException {
        CIMValue cIMValue = null;
        int n = -1;
        try {
            cIMValue = HscUtil.getCIMAttribute(this.mHostName, this.mObjectPath, MOF_PARTITION_TYPE);
            n = Integer.parseInt((String)cIMValue.getValue());
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
        return n;
    }

    public void powerOn(String string) throws HSCException {
        CIMInstance cIMInstance = null;
        CIMProperty cIMProperty = null;
        Object var4_4 = null;
        Enumeration enumeration = null;
        String string2 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        String string3 = null;
        String string4 = null;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        short s = 0;
        try {
            string2 = this.mIntName.substring(0, 3);
            s = Short.parseShort(string2);
            if (null != string) {
                enumeration = HscUtil.getCIMAssociationInst(this.mHostName, this.mObjectPath, "IBMHSC_PartitionProfile", "IBMHSC_Partition", "Element", "Setting", true, false, null);
                while (enumeration.hasMoreElements()) {
                    cIMInstance = (CIMInstance)enumeration.nextElement();
                    cIMProperty = cIMInstance.getProperty("UserDefinedName");
                    string4 = (String)cIMProperty.getValue().getValue();
                    if (!string.equals(string4)) continue;
                    cIMProperty = cIMInstance.getProperty("SettingID");
                    string3 = (String)cIMProperty.getValue().getValue();
                    break;
                }
                vector.add(new CIMProperty("partitionID", new CIMValue((Object)new UnsignedInt8(s))));
                vector.add(new CIMProperty("LparProfile", new CIMValue(string3)));
                if (IDebug.enabled()) {
                    System.out.println("Calling CIM method to activate LPAR profile");
                }
                HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "ActivateLparProfile", vector, vector2);
                if (IDebug.enabled()) {
                    System.out.println("Finished CIM method to activate LPAR profile");
                }
            } else {
                vector.add(new CIMProperty("partitionID", new CIMValue((Object)new UnsignedInt8(s))));
                if (IDebug.enabled()) {
                    System.out.println("Calling CIM method to activate LPAR");
                }
                HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "ActivatePartition", vector, vector2);
                if (IDebug.enabled()) {
                    System.out.println("Finished CIM method to activate LPAR");
                }
            }
        }
        catch (Throwable throwable) {
            throw new HSCException(throwable);
        }
    }

    public void powerOn(String string, short s) throws HSCException {
        CIMInstance cIMInstance = null;
        CIMProperty cIMProperty = null;
        Object var5_5 = null;
        Enumeration enumeration = null;
        String string2 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        String string3 = null;
        String string4 = null;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        short s2 = 0;
        try {
            string2 = this.mIntName.substring(0, 3);
            s2 = Short.parseShort(string2);
            if (null != string) {
                enumeration = HscUtil.getCIMAssociationInst(this.mHostName, this.mObjectPath, "IBMHSC_PartitionProfile", "IBMHSC_Partition", "Element", "Setting", true, false, null);
                while (enumeration.hasMoreElements()) {
                    cIMInstance = (CIMInstance)enumeration.nextElement();
                    cIMProperty = cIMInstance.getProperty("UserDefinedName");
                    string4 = (String)cIMProperty.getValue().getValue();
                    if (!string.equals(string4)) continue;
                    cIMProperty = cIMInstance.getProperty("SettingID");
                    string3 = (String)cIMProperty.getValue().getValue();
                    break;
                }
                vector.add(new CIMProperty("partitionID", new CIMValue((Object)new UnsignedInt8(s2))));
                vector.add(new CIMProperty("LparProfile", new CIMValue(string3)));
                vector.add(new CIMProperty("bootMode", new CIMValue((Object)new UnsignedInt8(s))));
                if (IDebug.enabled()) {
                    System.out.println("Calling CIM method to activate LPAR profile");
                }
                HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "ActivateProfileWithBootMode", vector, vector2);
                if (IDebug.enabled()) {
                    System.out.println("Finished CIM method to activate LPAR profile");
                }
            } else {
                vector.add(new CIMProperty("partitionID", new CIMValue((Object)new UnsignedInt8(s2))));
                vector.add(new CIMProperty("bootMode", new CIMValue((Object)new UnsignedInt8(s))));
                if (IDebug.enabled()) {
                    System.out.println("Calling CIM method to activate LPAR");
                }
                HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "ActivatePartitionWithBootMode", vector, vector2);
                if (IDebug.enabled()) {
                    System.out.println("Finished CIM method to activate LPAR");
                }
            }
        }
        catch (Throwable throwable) {
            throw new HSCException(throwable);
        }
    }

    public void powerOff() throws HSCException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            vector.add(new CIMProperty("ResetType", new CIMValue((Object)new UnsignedInt8(1))));
            if (IDebug.enabled()) {
                System.out.println("Calling CIM method to power off LPAR");
            }
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "OSReset", vector, vector2);
            if (IDebug.enabled()) {
                System.out.println("Finish CIM method to power off LPAR");
            }
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public void reset(String string) throws HSCException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            vector.add(new CIMProperty("ResetType", new CIMValue((Object)new UnsignedInt8(2))));
            if (IDebug.enabled()) {
                System.out.println("Calling CIM method to reset LPAR");
            }
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "OSReset", vector, vector2);
            if (IDebug.enabled()) {
                System.out.println("Finish CIM method to reset LPAR");
            }
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public void changePartition(Hashtable hashtable) throws HSCException {
        CIMClass cIMClass = null;
        CIMInstance cIMInstance = null;
        CIMInstance cIMInstance2 = null;
        CIMInstance cIMInstance3 = null;
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        CIMProperty cIMProperty = null;
        Object var10_10 = null;
        Enumeration enumeration = null;
        Enumeration enumeration2 = null;
        Object var13_13 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Vector<CIMProperty> vector = null;
        try {
            cIMInstance2 = HscUtil.getCIMInstance(this.mHostName, this.mObjectPath, false);
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                var13_13 = hashtable.get(string);
                if (string.equals("UserDefinedName") || string.equals(MOF_PARTITION_TYPE)) {
                    if (string.equals("UserDefinedName")) {
                        cIMInstance2.setProperty(string, new CIMValue((Object)var13_13));
                    }
                    if (string.equals(MOF_PARTITION_TYPE)) {
                        cIMInstance2.setProperty(string, new CIMValue((Object)new UnsignedInt8((String)var13_13)));
                    }
                    HscUtil.setCIMInstance(this.mHostName, this.mObjectPath, cIMInstance2);
                }
                if (!string.equals("DefaultProfileName")) continue;
                string2 = (String)hashtable.get(string);
                vector = new Vector<CIMProperty>();
                vector.add(new CIMProperty("hostName", new CIMValue((Object)this.mHostName)));
                enumeration2 = HscUtil.getCIMAssociationInst(this.mHostName, this.mObjectPath, "IBMHSC_PartitionProfile", "IBMHSC_Partition", "Element", "Setting", true, false, null);
                while (enumeration2.hasMoreElements()) {
                    cIMInstance3 = (CIMInstance)enumeration2.nextElement();
                    cIMProperty = cIMInstance3.getProperty("UserDefinedName");
                    string3 = (String)cIMProperty.getValue().getValue();
                    if (!string3.equals(string2)) continue;
                    cIMObjectPath3 = new CIMObjectPath("IBMHSC_LparProfile", cIMInstance3.getKeyValuePairs());
                    cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                }
                cIMObjectPath = new CIMObjectPath("IBMHSC_DefaultLparProfile");
                cIMClass = HscUtil.getCIMClass(this.mHostName, cIMObjectPath, false);
                cIMInstance = HscUtil.createNewCIMInstance(cIMClass);
                cIMObjectPath2 = this.mObjectPath;
                cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
                cIMInstance.setProperty("Element", new CIMValue((Object)this.mObjectPath));
                cIMInstance.setProperty("Setting", new CIMValue((Object)cIMObjectPath3));
                cIMObjectPath = new CIMObjectPath("IBMHSC_DefaultLparProfile", cIMInstance.getKeyValuePairs());
                cIMObjectPath.setNameSpace("root/ibmhscV3_2");
                HscUtil.createCIMInstance(this.mHostName, cIMObjectPath, cIMInstance);
            }
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public void createProfile(Hashtable hashtable) throws HSCException {
        CIMClass cIMClass = null;
        CIMObjectPath cIMObjectPath = null;
        CIMInstance cIMInstance = null;
        String string = null;
        try {
            string = this.getHostName();
            cIMObjectPath = new CIMObjectPath("IBMHSC_LparProfile");
            cIMClass = HscUtil.getCIMClass(string, cIMObjectPath, false);
            if (cIMClass != null) {
                cIMInstance = HscUtil.createNewCIMInstance(cIMClass);
                cIMInstance = this.buildProfileInParams(cIMInstance, hashtable);
                cIMObjectPath = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                cIMObjectPath.setNameSpace("root/ibmhscV3_2");
                cIMObjectPath = HscUtil.createCIMInstance(string, cIMObjectPath, cIMInstance);
            }
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public void deleteProfile(String string) throws HSCException {
        block7: {
            CIMObjectPath cIMObjectPath = null;
            CIMValue cIMValue = null;
            String string2 = null;
            String string3 = null;
            boolean bl = false;
            try {
                Vector vector = new Vector();
                Enumeration enumeration = HscUtil.getCIMAssociation(this.mHostName, this.mObjectPath, "IBMHSC_PartitionProfile", "IBMHSC_LparProfile", "Element", "Setting");
                while (enumeration.hasMoreElements()) {
                    cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                    cIMValue = HscUtil.getCIMAttribute(this.mHostName, cIMObjectPath, "UserDefinedName");
                    string3 = (String)cIMValue.getValue();
                    if (!string3.equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    HSCProfileCIMClient hSCProfileCIMClient;
                    int n = this.getPartitionState();
                    if (((short)n == 9 || (short)n == 6 || (short)n == 8) && string3.equals((hSCProfileCIMClient = this.getActivatedProfile()).getUserDefinedName())) {
                        string2 = HSCResourceBundleUtil.getMessage(HSC_COMMON_BUNDLE_NAME, "STATE_PROFILE_CANNOT_BE_DELETED");
                        throw new HSCException(string2);
                    }
                    short s = this.getPartitionSlotId();
                    if (s == 0) {
                        string2 = HSCResourceBundleUtil.getMessage(HSC_COMMON_BUNDLE_NAME, "TYPE_PROFILE_CANNOT_BE_DELETED");
                        throw new HSCException(string2);
                    }
                    Hashtable hashtable = this.getPartitionData();
                    String string4 = (String)hashtable.get("DefaultProfileName");
                    if (string3.equals(string4)) {
                        string2 = HSCResourceBundleUtil.getMessage(HSC_COMMON_BUNDLE_NAME, "DEFAULT_PROFILE_CANNOT_BE_DELETED");
                        throw new HSCException(string2);
                    }
                    HscUtil.deleteCIMInstance(this.mHostName, cIMObjectPath);
                    break block7;
                }
                string2 = HSCResourceBundleUtil.getMessage(HSC_COMMON_BUNDLE_NAME, "DELETE_PROFILE_NOT_FOUND");
                throw new HSCException(string2);
            }
            catch (CIMException cIMException) {
                throw new HSCException(cIMException);
            }
        }
    }

    public HSCRMCClient getRMCClient() {
        return this.mRMCClient;
    }

    public boolean dlparEnabled(String string) throws HSCException {
        try {
            CIMValue cIMValue = HscUtil.getCIMAttribute(this.mHostName, this.mObjectPath, MOF_DLPAR_CAPABILITIES);
            if (cIMValue == null) {
                return false;
            }
            String string2 = (String)cIMValue.getValue();
            int n = Integer.parseInt(string2);
            if (string.equals("slot")) {
                return (n & 4) != 0;
            }
            return n == 15;
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public boolean affinityPartition() throws HSCException {
        String string = null;
        try {
            CIMValue cIMValue = HscUtil.getCIMAttribute(this.mHostName, this.mObjectPath, MOF_PARTITION_TYPE);
            if (cIMValue == null) {
                return false;
            }
            string = (String)cIMValue.getValue();
            short s = Short.parseShort(string);
            return s == 3 || s == 2;
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public boolean smpPartition() throws HSCException {
        String string = null;
        try {
            CIMValue cIMValue = HscUtil.getCIMAttribute(this.mHostName, this.mObjectPath, MOF_PARTITION_TYPE);
            if (cIMValue == null) {
                return false;
            }
            string = (String)cIMValue.getValue();
            short s = Short.parseShort(string);
            return s == 0;
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public Enumeration getProfileObjectPathes() throws CIMException {
        return HscUtil.getCIMAssociation(this.mHostName, this.mObjectPath, "IBMHSC_PartitionProfile", "IBMHSC_LparProfile", "Element", "Setting");
    }

    public Hashtable getPartitionData() throws HSCException {
        CIMInstance cIMInstance = null;
        Object var2_2 = null;
        Enumeration enumeration = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        CIMValue cIMValue = null;
        Object var6_6 = null;
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt32 unsignedInt32 = null;
        String string = null;
        try {
            HSCProfileCIMClient hSCProfileCIMClient;
            hashtable.put("ID", this.mIntName);
            cIMInstance = HscUtil.getCIMInstance(this.mHostName, this.mObjectPath, false);
            cIMValue = cIMInstance.getProperty("UserDefinedName").getValue();
            if (cIMValue != null) {
                string = (String)cIMValue.getValue();
                hashtable.put("Name", string);
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_OP_PANEL_VALUE).getValue()) != null) {
                string = (String)cIMValue.getValue();
                hashtable.put(MOF_OP_PANEL_VALUE, string);
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_OS_LEVEL).getValue()) != null) {
                string = (String)cIMValue.getValue();
                hashtable.put("OsLevel", string);
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_OS_TYPE).getValue()) != null) {
                string = (String)cIMValue.getValue();
                hashtable.put("OsType", string);
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_PHYS_LOC_CODE).getValue()) != null) {
                string = (String)cIMValue.getValue();
                hashtable.put(MOF_PHYS_LOC_CODE, string);
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_PARTITION_STATE).getValue()) != null) {
                unsignedInt8 = (UnsignedInt8)cIMValue.getValue();
                hashtable.put(MOF_PARTITION_STATE, new Integer(unsignedInt8.intValue()));
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_PARTITION_TYPE).getValue()) != null) {
                unsignedInt8 = (UnsignedInt8)cIMValue.getValue();
                hashtable.put(MOF_PARTITION_TYPE, new Integer(unsignedInt8.intValue()));
            }
            if ((hSCProfileCIMClient = this.getActivatedProfile()) != null) {
                hashtable.put("ActivatedProfileName", hSCProfileCIMClient.getUserDefinedName());
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_DLPAR_CAPABILITIES).getValue()) != null) {
                unsignedInt32 = (UnsignedInt32)cIMValue.getValue();
                hashtable.put("DlparCapability", new Integer(unsignedInt32.intValue()));
            }
            if ((enumeration = HscUtil.getCIMAssociationInst(this.mHostName, this.mObjectPath, "IBMHSC_DefaultLparProfile", "IBMHSC_LparProfile", "Element", "Setting", true, false, null)).hasMoreElements()) {
                cIMInstance = (CIMInstance)enumeration.nextElement();
                string = (String)cIMInstance.getProperty("UserDefinedName").getValue().getValue();
                hashtable.put("DefaultProfileName", string);
            }
            return hashtable;
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public Vector getIOSlotData() throws HSCException {
        Object object;
        CIMInstance cIMInstance;
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = null;
        try {
            if (IDebug.enabled()) {
                System.out.println("LPAR getIOSlotData: starting CIM get association");
            }
            enumeration = HscUtil.getCIMAssociationInst(this.mHostName, this.mObjectPath, "IBMHSC_AllocatedSlot", "IBMHSC_PCISlot", "GroupComponent", "PartComponent", true, false, null);
            if (IDebug.enabled()) {
                System.out.println("LPAR getIOSlotData: Finished CIM get association");
            }
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
        if (enumeration == null) {
            return null;
        }
        TreeMap treeMap = new TreeMap();
        HSCCECCIMClient hSCCECCIMClient = (HSCCECCIMClient)this.mParentObject;
        while (enumeration.hasMoreElements()) {
            cIMInstance = (CIMInstance)enumeration.nextElement();
            object = (UnsignedInt8)cIMInstance.getProperty(MOF_PCI_BUS).getValue().getValue();
            hSCCECCIMClient.getSlotData(cIMInstance, treeMap, false);
        }
        cIMInstance = new Vector();
        if (treeMap.size() == 0) {
            return cIMInstance;
        }
        object = treeMap.tailMap(treeMap.firstKey());
        Iterator iterator = object.keySet().iterator();
        while (iterator.hasNext()) {
            cIMInstance.addElement(object.get(iterator.next()));
        }
        return cIMInstance;
    }

    public Vector getChangableIOSlotData() throws HSCException {
        HSCProfileCIMClient hSCProfileCIMClient = this.getActivatedProfile();
        Hashtable hashtable = hSCProfileCIMClient.getAttributes(null);
        Object v = hashtable.get("IODrawer");
        Vector vector = (Vector)v;
        Vector vector2 = (Vector)hashtable.get("IOSlots");
        Vector vector3 = (Vector)hashtable.get("IORequirement");
        Vector vector4 = this.getIOSlotData();
        if (vector == null || vector.size() == 0) {
            return vector4;
        }
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector3.elementAt(n);
            String string2 = (String)vector.elementAt(n);
            short s = ((UnsignedInt8)vector2.elementAt(n)).shortValue();
            if (string.equals(REQUIRED_VALUE)) {
                int n2 = 0;
                while (n2 < vector4.size()) {
                    Hashtable hashtable2 = (Hashtable)vector4.elementAt(n2);
                    if (string2.equals((String)hashtable2.get("IODrawerDeviceID")) && s == (Short)hashtable2.get(MOF_SLOT_ID)) {
                        vector4.remove(n2--);
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return vector4;
    }

    public Hashtable getProcessorData() throws HSCException {
        HSCCECCIMClient hSCCECCIMClient = (HSCCECCIMClient)this.mParentObject;
        Hashtable hashtable = hSCCECCIMClient.getProcessorData(this.mIntName);
        hashtable.put("userNames", this.mUserDefinedName);
        hashtable.put("intNames", this.mIntName);
        return hashtable;
    }

    public Hashtable getMemoryData() throws HSCException {
        HSCCECCIMClient hSCCECCIMClient = (HSCCECCIMClient)this.mParentObject;
        Hashtable hashtable = hSCCECCIMClient.getMemoryData(this.mIntName);
        hashtable.put("userNames", this.mUserDefinedName);
        hashtable.put("intNames", this.mIntName);
        return hashtable;
    }

    public Vector getRecoverIOData() throws HSCException {
        HSCCECCIMClient hSCCECCIMClient = (HSCCECCIMClient)this.mParentObject;
        return hSCCECCIMClient.getRecoverIOData();
    }

    public Hashtable getMoveToPartitionNames(String string) throws HSCException {
        HSCCECCIMClient hSCCECCIMClient = (HSCCECCIMClient)this.mParentObject;
        return hSCCECCIMClient.getMoveToParNames(this.mIntName, string);
    }

    public HSCProfileCIMClient getActivatedProfile() throws HSCException {
        try {
            Enumeration enumeration = HscUtil.getCIMAssociation(this.mHostName, this.mObjectPath, "IBMHSC_ActivatedLparProfile", "IBMHSC_LparProfile", null, null);
            if (!enumeration.hasMoreElements()) {
                return null;
            }
            CIMObjectPath cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
            return new HSCProfileCIMClient(this.mHostName, this, null, cIMObjectPath);
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public short getPartitionSlotId() {
        return ((HSCCECCIMClient)this.mParentObject).getPartitionSlotId(this.mIntName);
    }

    public int addCpu(int n, int n2, short s) throws HSCException {
        String string;
        block19: {
            boolean bl = false;
            int n3 = 0;
            string = this.getMessage("INFO_ADD_HMC", INFO_ADD_HMC, new String[]{INFO_CPU_RES});
            if (IDebug.enabled()) {
                System.out.println("Num = " + n);
                System.out.println("Timeout = " + n2);
                System.out.println("DetailLevel = " + s);
            }
            try {
                if (IDebug.enabled()) {
                    System.out.println("Starting CSP addCpu call");
                }
                n3 = this.hmcCPUMEMDLPAROp(MOF_CPU_LPAR_TASK, n, this, MOF_CPU_QUANTITY, false);
                if (IDebug.enabled()) {
                    System.out.println("Finished CSP addCpu call");
                }
                if (n3 < n) {
                    string = string + this.getMessage("ERR_CPU_HMC", ERR_CPU_HMC, new String[]{"" + n, "" + n3});
                    bl = true;
                } else {
                    string = string + this.getMessage("INFO_ADD_HMC_SUCC", INFO_ADD_HMC_SUCC, new String[]{INFO_CPU_RES});
                }
            }
            catch (Throwable throwable) {
                string = string + ERR_HMC_EXCEPTION;
                throw new HSCException(string, throwable);
            }
            if (n3 == 0) {
                throw new HSCException(string);
            }
            try {
                string = string + this.getMessage("INFO_ADD_AIX", INFO_ADD_AIX, new String[]{INFO_CPU_RES});
                if (IDebug.enabled()) {
                    System.out.println("Starting RMC addCpu call");
                }
                this.mRMCClient.rmcDLPAROp(n3, n2, s, "cpu", null, "a");
                if (IDebug.enabled()) {
                    System.out.println("Finished RMC addCpu call");
                }
                if (!bl) {
                    return n3;
                }
                string = string + this.getMessage("INFO_ADD_AIX_SUCC", INFO_ADD_AIX_SUCC, new String[]{INFO_CPU_RES});
                String string2 = "DLPAR: Completed adding cpus to the partition.";
                HSCLogUtils.logSystemEvent((short)2154, string2, null, null);
            }
            catch (HSCRMCException hSCRMCException) {
                string = string + this.getMessage(hSCRMCException);
                n3 -= hSCRMCException.getNumberOfSuccesses();
                string = string + this.getMessage("INFO_HMC_ROLLBACK_ADD", INFO_HMC_ROLLBACK_ADD, new String[]{INFO_CPU_RES});
                try {
                    if (IDebug.enabled()) {
                        System.out.println("Starting rollback for addCpu");
                    }
                    int n4 = this.hmcCPUMEMDLPAROp(MOF_CPU_LPAR_TASK, n3, null, MOF_CPU_QUANTITY, true);
                    if (IDebug.enabled()) {
                        System.out.println("Finish rollback for addCpu");
                    }
                    if (n4 < n3) {
                        string = string + this.getMessage("ERR_CPU_HMC", ERR_CPU_HMC, new String[]{"" + n3, "" + n4});
                        string = string + ERR_OUT_OF_SYNC;
                        bl = true;
                    } else {
                        string = string + INFO_HMC_ROLLBACK_SUCC;
                    }
                }
                catch (Throwable throwable) {
                    string = string + ERR_HMC_EXCEPTION;
                    throw new HSCException(string, throwable);
                }
                if (bl) break block19;
                throw hSCRMCException;
            }
        }
        throw new HSCException(string);
    }

    public int removeCpu(int n, int n2, short s) throws HSCException {
        int n3 = 0;
        HSCRMCException hSCRMCException = null;
        String string = this.getMessage("INFO_REMOVE_AIX", INFO_REMOVE_AIX, new String[]{INFO_CPU_RES});
        try {
            if (IDebug.enabled()) {
                System.out.println("num = " + n);
                System.out.println("timeout = " + n2);
                System.out.println("detailLevel = " + s);
                System.out.println("Starting RMC removeCpu call");
            }
            n3 = this.mRMCClient.rmcDLPAROp(n, n2, s, "cpu", null, "r");
            if (IDebug.enabled()) {
                System.out.println("Finished RMC removeCpu call");
            }
            string = string + this.getMessage("INFO_REMOVE_AIX_SUCC", INFO_REMOVE_AIX_SUCC, new String[]{INFO_CPU_RES});
        }
        catch (HSCRMCException hSCRMCException2) {
            string = string + this.getMessage(hSCRMCException2);
            n3 = hSCRMCException2.getNumberOfSuccesses();
            hSCRMCException = hSCRMCException2;
        }
        if (n3 > 0) {
            string = string + this.getMessage("INFO_REMOVE_HMC", INFO_REMOVE_HMC, new String[]{INFO_CPU_RES});
            try {
                if (IDebug.enabled()) {
                    System.out.println("Starting HSC removeCpu call");
                }
                int n4 = this.hmcCPUMEMDLPAROp(MOF_CPU_LPAR_TASK, n3, null, MOF_CPU_QUANTITY, false);
                if (IDebug.enabled()) {
                    System.out.println("Starting HSC removeCpu call");
                }
                if (n4 < n3) {
                    string = string + this.getMessage("ERR_CPU_HMC", ERR_CPU_HMC, new String[]{"" + n3, "" + n4});
                    string = string + ERR_OUT_OF_SYNC;
                    throw new HSCException(string);
                }
                String string2 = "DLPAR: Completed removing cpus from the partition.";
                HSCLogUtils.logSystemEvent((short)2155, string2, null, null);
            }
            catch (Throwable throwable) {
                string = string + ERR_HMC_EXCEPTION;
                throw new HSCException(string, throwable);
            }
        }
        if (hSCRMCException != null) {
            throw hSCRMCException;
        }
        return n3;
    }

    public int moveCpu(int n, String string, boolean bl, int n2, short s) throws HSCException {
        int n3 = 0;
        HSCRMCException hSCRMCException = null;
        HSCLPARCIMClient hSCLPARCIMClient = HSCLPARCIMClient.createInstance(this.mHostName, this.mParentObject.getIntName(), string, bl);
        String string2 = this.getMessage("INFO_REMOVE_AIX", INFO_REMOVE_AIX, new String[]{INFO_CPU_RES});
        try {
            if (IDebug.enabled()) {
                System.out.println("dest = " + string);
                System.out.println("timeout = " + n2);
                System.out.println("detailLevel = " + s);
                System.out.println("MOVE CPU: Starting RMC removeCpu call");
            }
            n3 = this.mRMCClient.rmcDLPAROp(n, n2, s, "cpu", null, "r");
            if (IDebug.enabled()) {
                System.out.println("MOVE CPU: Finish RMC removeCpu call");
            }
            string2 = string2 + this.getMessage("INFO_REMOVE_AIX_SUCC", INFO_REMOVE_AIX_SUCC, new String[]{INFO_CPU_RES});
        }
        catch (HSCRMCException hSCRMCException2) {
            string2 = string2 + this.getMessage(hSCRMCException2);
            n3 = hSCRMCException2.getNumberOfSuccesses();
            hSCRMCException = hSCRMCException2;
        }
        if (n3 > 0) {
            string2 = string2 + this.getMessage("INFO_MOVE_HMC", INFO_MOVE_HMC, new String[]{INFO_CPU_RES});
            try {
                if (IDebug.enabled()) {
                    System.out.println("MOVE CPU: Starting CSP removeCpu call");
                }
                int n4 = this.hmcCPUMEMDLPAROp(MOF_CPU_LPAR_TASK, n3, hSCLPARCIMClient, MOF_CPU_QUANTITY, false);
                if (IDebug.enabled()) {
                    System.out.println("MOVE CPU: Finish CSP removeCpu call");
                }
                if (n4 != n3) {
                    string2 = string2 + this.getMessage("ERR_CPU_HMC", ERR_CPU_HMC, new String[]{"" + n3, "" + n4});
                    string2 = string2 + ERR_OUT_OF_SYNC;
                    throw new HSCException(string2);
                }
                string2 = string2 + this.getMessage("INFO_MOVE_HMC_SUCC", INFO_MOVE_HMC_SUCC, new String[]{INFO_CPU_RES});
            }
            catch (Throwable throwable) {
                string2 = string2 + ERR_HMC_EXCEPTION;
                throw new HSCException(string2, throwable);
            }
            try {
                string2 = string2 + this.getMessage("INFO_ADD_AIX", INFO_ADD_AIX, new String[]{INFO_CPU_RES});
                if (IDebug.enabled()) {
                    System.out.println("MOVE CPU: Starting RMC addCpu call");
                }
                hSCLPARCIMClient.getRMCClient().rmcDLPAROp(n3, n2, s, "cpu", null, "a");
                if (IDebug.enabled()) {
                    System.out.println("MOVE CPU: Finished RMC addCpu call");
                }
            }
            catch (HSCRMCException hSCRMCException3) {
                string2 = string2 + this.getMessage(hSCRMCException3);
                string2 = string2 + this.getMessage("INFO_HMC_ROLLBACK_ADD", INFO_HMC_ROLLBACK_ADD, new String[]{INFO_CPU_RES});
                try {
                    n3 -= hSCRMCException3.getNumberOfSuccesses();
                    if (IDebug.enabled()) {
                        System.out.println("MOVE CPU: Start rolling back CSP call");
                    }
                    int n5 = hSCLPARCIMClient.hmcCPUMEMDLPAROp(MOF_CPU_LPAR_TASK, n3, null, MOF_CPU_QUANTITY, true);
                    if (IDebug.enabled()) {
                        System.out.println("MOVE CPU: Finished rolling back CSP call");
                    }
                    if (n5 != n3) {
                        string2 = string2 + this.getMessage("ERR_CPU_HMC", ERR_CPU_HMC, new String[]{"" + n3, "" + n5});
                        throw new HSCException(string2);
                    }
                    string2 = string2 + INFO_HMC_ROLLBACK_SUCC;
                }
                catch (Throwable throwable) {
                    string2 = string2 + ERR_HMC_EXCEPTION;
                    throw new HSCException(string2, throwable);
                }
                if (hSCRMCException == null) {
                    throw hSCRMCException3;
                }
                throw new HSCRMCException(string2, 0);
            }
        }
        if (hSCRMCException != null) {
            throw hSCRMCException;
        }
        String string3 = "DLPAR: Completed moving cpus.";
        HSCLogUtils.logSystemEvent((short)2156, string3, null, null);
        return n3;
    }

    public int addMem(int n, int n2, short s) throws HSCException {
        int n3 = 0;
        String string = this.getMessage("INFO_ADD_HMC", INFO_ADD_HMC, new String[]{INFO_MEM_RES});
        try {
            if (IDebug.enabled()) {
                System.out.println("num = " + n);
                System.out.println("timeout = " + n2);
                System.out.println("detailLevel = " + s);
                System.out.println("Start CSP addMem");
            }
            this.hmcCPUMEMDLPAROp(MOF_MEM_LPAR_TASK, n, this, MOF_LMB_QUANTITY, false);
            if (IDebug.enabled()) {
                System.out.println("Finish CSP addMem");
            }
            string = string + this.getMessage("INFO_ADD_HMC_SUCC", INFO_ADD_HMC_SUCC, new String[]{INFO_MEM_RES});
        }
        catch (Throwable throwable) {
            string = string + ERR_HMC_EXCEPTION;
            throw new HSCException(string, throwable);
        }
        string = string + this.getMessage("INFO_ADD_AIX", INFO_ADD_AIX, new String[]{INFO_MEM_RES});
        try {
            if (IDebug.enabled()) {
                System.out.println("Start RMC addMem");
            }
            n3 = this.mRMCClient.rmcDLPAROp(n, n2, s, "mem", null, "a");
            if (IDebug.enabled()) {
                System.out.println("Finish RMC addMem");
            }
        }
        catch (HSCRMCException hSCRMCException) {
            string = string + this.getMessage(hSCRMCException);
            string = string + this.getMessage("INFO_HMC_ROLLBACK_ADD", INFO_HMC_ROLLBACK_ADD, new String[]{INFO_MEM_RES});
            try {
                if (IDebug.enabled()) {
                    System.out.println("Start rollback for addMem");
                }
                this.hmcCPUMEMDLPAROp(MOF_MEM_LPAR_TASK, n - hSCRMCException.getNumberOfSuccesses(), null, MOF_LMB_QUANTITY, true);
                if (IDebug.enabled()) {
                    System.out.println("Finish rollabck for addMem");
                }
            }
            catch (Throwable throwable) {
                string = string + ERR_HMC_EXCEPTION;
                throw new HSCException(string, throwable);
            }
            throw hSCRMCException;
        }
        String string2 = "DLPAR: Completed adding memory to the partition.";
        HSCLogUtils.logSystemEvent((short)2157, string2, null, null);
        return n3;
    }

    public int removeMem(int n, int n2, short s) throws HSCException {
        int n3 = 0;
        String string = this.getMessage("INFO_REMOVE_HMC", INFO_REMOVE_HMC, new String[]{INFO_MEM_RES});
        try {
            if (IDebug.enabled()) {
                System.out.println("timeout = " + n2);
                System.out.println("detailLevel = " + s);
                System.out.println("Start CSP for removeMem");
            }
            this.hmcCPUMEMDLPAROp(MOF_MEM_LPAR_TASK, n, null, MOF_LMB_QUANTITY, false);
            if (IDebug.enabled()) {
                System.out.println("Finish CSP for removeMem");
            }
            string = string + this.getMessage("INFO_REMOVE_HMC_SUCC", INFO_REMOVE_HMC_SUCC, new String[]{INFO_MEM_RES});
        }
        catch (Throwable throwable) {
            string = string + ERR_HMC_EXCEPTION;
            throw new HSCException(string, throwable);
        }
        try {
            string = string + this.getMessage("INFO_REMOVE_AIX", INFO_REMOVE_AIX, new String[]{INFO_MEM_RES});
            if (IDebug.enabled()) {
                System.out.println("Start RMC for removeMem");
            }
            n3 = this.mRMCClient.rmcDLPAROp(n, n2, s, "mem", null, "r");
            if (IDebug.enabled()) {
                System.out.println("Finish RMC for removeMem");
            }
        }
        catch (HSCRMCException hSCRMCException) {
            string = string + this.getMessage(hSCRMCException);
            string = string + this.getMessage("INFO_HMC_ROLLBACK_REMOVE", INFO_HMC_ROLLBACK_REMOVE, new String[]{INFO_MEM_RES});
            try {
                if (IDebug.enabled()) {
                    System.out.println("Start rollback for removeMem");
                }
                this.hmcCPUMEMDLPAROp(MOF_MEM_LPAR_TASK, n - hSCRMCException.getNumberOfSuccesses(), this, MOF_LMB_QUANTITY, true);
                if (IDebug.enabled()) {
                    System.out.println("Finish rollback for removeMem");
                }
            }
            catch (Throwable throwable) {
                string = string + ERR_HMC_EXCEPTION;
                throw new HSCException(string, throwable);
            }
            throw hSCRMCException;
        }
        String string2 = "DLPAR: Completed removing memory from the partition.";
        HSCLogUtils.logSystemEvent((short)2158, string2, null, null);
        return n3;
    }

    public int moveMem(int n, String string, boolean bl, int n2, short s) throws HSCException {
        String string2 = this.getMessage("INFO_MOVE_HMC", INFO_MOVE_HMC, new String[]{INFO_MEM_RES});
        HSCLPARCIMClient hSCLPARCIMClient = HSCLPARCIMClient.createInstance(this.mHostName, this.mParentObject.getIntName(), string, bl);
        try {
            if (IDebug.enabled()) {
                System.out.println("dest = " + string);
                System.out.println("timeout = " + n2);
                System.out.println("detailLevel = " + s);
                System.out.println("MOVE MEM: Start CSP for moveMem");
            }
            this.hmcCPUMEMDLPAROp(MOF_MEM_LPAR_TASK, n, hSCLPARCIMClient, MOF_LMB_QUANTITY, false);
            if (IDebug.enabled()) {
                System.out.println("MOVE MEM: FINISH CSP for moveMem");
            }
            string2 = string2 + this.getMessage("INFO_MOVE_HMC_SUCC", INFO_MOVE_HMC_SUCC, new String[]{INFO_MEM_RES});
        }
        catch (Throwable throwable) {
            string2 = string2 + ERR_HMC_EXCEPTION;
            throw new HSCException(string2, throwable);
        }
        int n3 = 0;
        HSCRMCException hSCRMCException = null;
        string2 = string2 + this.getMessage("INFO_REMOVE_AIX", INFO_REMOVE_AIX, new String[]{INFO_MEM_RES});
        try {
            if (IDebug.enabled()) {
                System.out.println("MOVE MEM: Start RMC for removeMem");
            }
            n3 = this.mRMCClient.rmcDLPAROp(n, n2, s, "mem", null, "r");
            if (IDebug.enabled()) {
                System.out.println("MOVE MEM: Finish RMC for removeMem");
            }
            string2 = string2 + this.getMessage("INFO_REMOVE_AIX_SUCC", INFO_REMOVE_AIX_SUCC, new String[]{INFO_MEM_RES});
        }
        catch (HSCRMCException hSCRMCException2) {
            string2 = string2 + this.getMessage(hSCRMCException2);
            string2 = string2 + this.getMessage("INFO_HMC_ROLLBACK_REMOVE", INFO_HMC_ROLLBACK_REMOVE, new String[]{INFO_MEM_RES});
            n3 = hSCRMCException2.getNumberOfSuccesses();
            try {
                if (IDebug.enabled()) {
                    System.out.println("MOVE MEM: Start Rollback for removeMem");
                }
                hSCLPARCIMClient.hmcCPUMEMDLPAROp(MOF_MEM_LPAR_TASK, n - n3, this, MOF_LMB_QUANTITY, true);
                if (IDebug.enabled()) {
                    System.out.println("MOVE MEM: Finish Rollback for removeMem");
                }
            }
            catch (Throwable throwable) {
                string2 = string2 + ERR_HMC_EXCEPTION;
                throw new HSCException(string2, throwable);
            }
            hSCRMCException = hSCRMCException2;
        }
        if (n3 > 0) {
            string2 = string2 + this.getMessage("INFO_ADD_AIX", INFO_ADD_AIX, new String[]{INFO_MEM_RES});
            try {
                if (IDebug.enabled()) {
                    System.out.println("MOVE MEM: Start RMC for addMem");
                }
                hSCLPARCIMClient.getRMCClient().rmcDLPAROp(n3, n2, s, "mem", null, "a");
                if (IDebug.enabled()) {
                    System.out.println("MOVE MEM: Finish RMC for addMem");
                }
            }
            catch (HSCRMCException hSCRMCException3) {
                string2 = string2 + this.getMessage(hSCRMCException3);
                string2 = string2 + this.getMessage("INFO_HMC_ROLLBACK_ADD", INFO_HMC_ROLLBACK_ADD, new String[]{INFO_MEM_RES});
                try {
                    if (IDebug.enabled()) {
                        System.out.println("MOVE MEM: Start rollback for addMem");
                    }
                    hSCLPARCIMClient.hmcCPUMEMDLPAROp(MOF_MEM_LPAR_TASK, n3 - hSCRMCException3.getNumberOfSuccesses(), null, MOF_LMB_QUANTITY, true);
                    if (IDebug.enabled()) {
                        System.out.println("MOVE MEM: Finish Rollabck for addMem");
                    }
                }
                catch (Throwable throwable) {
                    string2 = string2 + ERR_HMC_EXCEPTION;
                    throw new HSCException(string2, throwable);
                }
                if (hSCRMCException != null) {
                    throw new HSCRMCException(string2, 0);
                }
                throw hSCRMCException3;
            }
        }
        if (hSCRMCException != null) {
            throw hSCRMCException;
        }
        String string3 = "DLPAR: Completed moving memory.";
        HSCLogUtils.logSystemEvent((short)2159, string3, null, null);
        return n3;
    }

    public int addSlots(Hashtable hashtable, int n, short s) throws HSCException {
        String string;
        boolean bl;
        block19: {
            String[] stringArray;
            bl = false;
            string = this.getMessage("INFO_ADD_HMC", INFO_ADD_HMC, new String[]{INFO_SLOT_RES});
            try {
                if (IDebug.enabled()) {
                    System.out.println("timeout = " + n);
                    System.out.println("detailLevel = " + s);
                    System.out.println("Start CSP for addSlot");
                }
                stringArray = this.hmcSlotDLPAROp(hashtable, this);
                if (IDebug.enabled()) {
                    System.out.println("Finish CSP for addMem");
                }
                if (null == stringArray) {
                    string = string + this.getMessage("INFO_ADD_HMC_SUCC", INFO_ADD_HMC_SUCC, new String[]{INFO_SLOT_RES});
                } else {
                    string = string + (String)stringArray.elementAt(0);
                    boolean[] blArray = (boolean[])stringArray.elementAt(1);
                    hashtable = this.slotInfoTrim(hashtable, blArray, false);
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                string = string + ERR_HMC_EXCEPTION;
                throw new HSCException(string, throwable);
            }
            if (hashtable.size() == 0) {
                throw new HSCException(string);
            }
            string = string + this.getMessage("INFO_ADD_AIX", INFO_ADD_AIX, new String[]{INFO_SLOT_RES});
            stringArray = (String[])hashtable.get("SlotLocation");
            try {
                if (IDebug.enabled()) {
                    System.out.println("Start RMC for addSlot");
                }
                int n2 = this.mRMCClient.rmcDLPAROp(stringArray.length, n, s, "slot", stringArray, "a");
                if (IDebug.enabled()) {
                    System.out.println("Finish RMC for addSlot");
                }
                if (!bl) {
                    return n2;
                }
                string = string + this.getMessage("INFO_ADD_AIX_SUCC", INFO_ADD_AIX_SUCC, new String[]{INFO_SLOT_RES});
            }
            catch (HSCRMCException hSCRMCException) {
                string = string + this.getMessage(hSCRMCException);
                string = string + this.getMessage("INFO_HMC_ROLLBACK_ADD", INFO_HMC_ROLLBACK_ADD, new String[]{INFO_SLOT_RES});
                Hashtable hashtable2 = this.slotInfoTrim(hashtable, hSCRMCException.getNumberOfSuccesses(), true);
                try {
                    if (IDebug.enabled()) {
                        System.out.println("Start rollback for addSlot");
                    }
                    Vector vector = this.hmcSlotDLPAROp(hashtable2, null);
                    if (IDebug.enabled()) {
                        System.out.println("Finish rollback for addSlot");
                    }
                    if (vector != null) {
                        string = string + (String)vector.elementAt(0);
                        string = string + ERR_OUT_OF_SYNC;
                        bl = true;
                    } else {
                        string = string + INFO_HMC_ROLLBACK_SUCC;
                    }
                }
                catch (Throwable throwable) {
                    string = string + ERR_HMC_EXCEPTION;
                    throw new HSCException(string, throwable);
                }
                if (bl) break block19;
                throw hSCRMCException;
            }
        }
        if (bl) {
            throw new HSCException(string);
        }
        String string2 = "DLPAR: Completed adding slots to the partition.";
        HSCLogUtils.logSystemEvent((short)2160, string2, null, null);
        return hashtable.size();
    }

    public int removeSlots(Hashtable hashtable, int n, short s) throws HSCException {
        Object object;
        String string = this.getMessage("INFO_REMOVE_AIX", INFO_REMOVE_AIX, new String[]{INFO_SLOT_RES});
        int n2 = 0;
        HSCRMCException hSCRMCException = null;
        String[] stringArray = (String[])hashtable.get("SlotLocation");
        n2 = hashtable.size();
        try {
            if (IDebug.enabled()) {
                System.out.println("timeout = " + n);
                System.out.println("detailLevel = " + s);
                System.out.println("Start RMC for removeSlot");
            }
            n2 = this.mRMCClient.rmcDLPAROp(stringArray.length, n, s, "slot", stringArray, "r");
            if (IDebug.enabled()) {
                System.out.println("Finish RMC for removeSlot");
            }
            string = string + this.getMessage("INFO_REMOVE_AIX_SUCC", INFO_REMOVE_AIX_SUCC, new String[]{INFO_SLOT_RES});
        }
        catch (HSCRMCException hSCRMCException2) {
            string = string + this.getMessage(hSCRMCException2);
            n2 = hSCRMCException2.getNumberOfSuccesses();
            if (n2 > 0) {
                hashtable = this.slotInfoTrim(hashtable, n2, false);
            }
            hSCRMCException = hSCRMCException2;
        }
        if (n2 > 0) {
            string = string + this.getMessage("INFO_REMOVE_HMC", INFO_REMOVE_HMC, new String[]{INFO_SLOT_RES});
            try {
                if (IDebug.enabled()) {
                    System.out.println("Start CSP for removeSlot");
                }
                object = this.hmcSlotDLPAROp(hashtable, null);
                if (IDebug.enabled()) {
                    System.out.println("Finish CSP for removeSlot");
                }
                if (object != null) {
                    string = string + (String)((Vector)object).elementAt(0);
                    string = string + ERR_OUT_OF_SYNC;
                    throw new HSCException(string);
                }
            }
            catch (Throwable throwable) {
                string = string + ERR_HMC_EXCEPTION;
                throw new HSCException(string, throwable);
            }
        }
        if (hSCRMCException != null) {
            throw hSCRMCException;
        }
        object = "DLPAR: Completed removing slots from the partition.";
        HSCLogUtils.logSystemEvent((short)2161, (String)object, null, null);
        return n2;
    }

    public int moveSlots(Hashtable hashtable, String string, boolean bl, int n, short s) throws HSCException {
        Object object;
        int n2 = 0;
        HSCRMCException hSCRMCException = null;
        HSCLPARCIMClient hSCLPARCIMClient = HSCLPARCIMClient.createInstance(this.mHostName, this.mParentObject.getIntName(), string, bl);
        String string2 = this.getMessage("INFO_REMOVE_AIX", INFO_REMOVE_AIX, new String[]{INFO_SLOT_RES});
        String[] stringArray = (String[])hashtable.get("SlotLocation");
        try {
            if (IDebug.enabled()) {
                System.out.println("MOVE SLOT: dest =" + string);
                System.out.println("MOVE SLOT: timeout =" + n);
                System.out.println("MOVE SLOT: detailLevel =" + s);
            }
            n2 = this.mRMCClient.rmcDLPAROp(stringArray.length, n, s, "slot", stringArray, "r");
            if (IDebug.enabled()) {
                System.out.println("MOVE SLOT: Finish RMC for removeSlot");
            }
            string2 = string2 + this.getMessage("INFO_REMOVE_AIX_SUCC", INFO_REMOVE_AIX_SUCC, new String[]{INFO_SLOT_RES});
        }
        catch (HSCRMCException hSCRMCException2) {
            string2 = string2 + this.getMessage(hSCRMCException2);
            n2 = hSCRMCException2.getNumberOfSuccesses();
            if (n2 > 0) {
                hashtable = this.slotInfoTrim(hashtable, n2, false);
            }
            hSCRMCException = hSCRMCException2;
        }
        if (n2 > 0) {
            string2 = string2 + this.getMessage("INFO_MOVE_HMC", INFO_MOVE_HMC, new String[]{INFO_SLOT_RES});
            try {
                if (IDebug.enabled()) {
                    System.out.println("MOVE SLOT: Start CSP for moveSlot");
                }
                object = this.hmcSlotDLPAROp(hashtable, hSCLPARCIMClient);
                if (IDebug.enabled()) {
                    System.out.println("MOVE SLOT: Finish CSP for moveSlot");
                }
                if (object != null) {
                    string2 = string2 + (String)((Vector)object).elementAt(0);
                    string2 = string2 + ERR_OUT_OF_SYNC;
                    throw new HSCException(string2);
                }
                string2 = string2 + this.getMessage("INFO_MOVE_HMC_SUCC", INFO_MOVE_HMC_SUCC, new String[]{INFO_SLOT_RES});
            }
            catch (Throwable throwable) {
                string2 = string2 + ERR_HMC_EXCEPTION;
                throw new HSCException(string2, throwable);
            }
            stringArray = (String[])hashtable.get("SlotLocation");
            try {
                string2 = string2 + this.getMessage("INFO_ADD_AIX", INFO_ADD_AIX, new String[]{INFO_SLOT_RES});
                if (IDebug.enabled()) {
                    System.out.println("MOVE SLOT: Start RMC for addSlot");
                }
                hSCLPARCIMClient.getRMCClient().rmcDLPAROp(n2, n, s, "slot", stringArray, "a");
                if (IDebug.enabled()) {
                    System.out.println("MOVE SLOT: Finish RMC for addSlot");
                }
            }
            catch (HSCRMCException hSCRMCException3) {
                string2 = string2 + this.getMessage(hSCRMCException3);
                string2 = string2 + this.getMessage("INFO_HMC_ROLLBACK_ADD", INFO_HMC_ROLLBACK_ADD, new String[]{INFO_SLOT_RES});
                Hashtable hashtable2 = this.slotInfoTrim(hashtable, hSCRMCException3.getNumberOfSuccesses(), true);
                try {
                    if (IDebug.enabled()) {
                        System.out.println("MOVE SLOT: Start Rollback for addSlot");
                    }
                    Vector vector = hSCLPARCIMClient.hmcSlotDLPAROp(hashtable2, null);
                    if (IDebug.enabled()) {
                        System.out.println("MOVE SLOT: Finish Rollback for addSlot");
                    }
                    if (vector != null) {
                        string2 = string2 + (String)vector.elementAt(0);
                        string2 = string2 + ERR_OUT_OF_SYNC;
                        throw new HSCException(string2);
                    }
                }
                catch (Throwable throwable) {
                    string2 = string2 + ERR_HMC_EXCEPTION;
                    throw new HSCException(string2, throwable);
                }
                if (hSCRMCException != null) {
                    throw new HSCRMCException(string2, 0);
                }
                throw hSCRMCException3;
            }
        }
        if (hSCRMCException != null) {
            throw hSCRMCException;
        }
        object = "DLPAR: Completed moving slots from the partition.";
        HSCLogUtils.logSystemEvent((short)2162, (String)object, null, null);
        return n2;
    }

    public void activate(String string) throws HSCException {
        Object object;
        try {
            object = null;
            short s = this.getPartitionSlotId();
            if (string != null && string.length() != 0) {
                object = new Vector();
                ((Vector)object).add(new CIMProperty("partitionID", new CIMValue((Object)new Short(s))));
                ((Vector)object).add(new CIMProperty("LparProfile", new CIMValue((Object)string)));
                if (IDebug.enabled()) {
                    System.out.println("Start CIM activate profile");
                }
                HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "ActivateLparProfile", (Vector)object, new Vector());
                if (IDebug.enabled()) {
                    System.out.println("Finish CIM activate profile");
                }
            } else {
                object = new Vector<CIMProperty>();
                ((Vector)object).add(new CIMProperty("partitionID", new CIMValue((Object)new Short(s))));
                if (IDebug.enabled()) {
                    System.out.println("Start CIM activate partition");
                }
                HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "ActivatePartition", object, new Vector());
                if (IDebug.enabled()) {
                    System.out.println("Finish CIM activate partition");
                }
            }
        }
        catch (CIMException cIMException) {
            String string2 = cIMException.toString();
            HSCRecoveryException hSCRecoveryException = null;
            if (string2.indexOf("290F") != -1) {
                hSCRecoveryException = new HSCRecoveryException(string2, HSCRecoveryException.CPU_RES_TYPE);
            } else if (string2.indexOf("2911") != -1) {
                hSCRecoveryException = new HSCRecoveryException(string2, HSCRecoveryException.MEM_RES_TYPE);
            } else if (string2.indexOf("2910") != -1) {
                hSCRecoveryException = new HSCRecoveryException(string2, HSCRecoveryException.IO_RES_TYPE);
            } else {
                System.out.println("not recovery exception");
            }
            if (hSCRecoveryException != null) {
                throw hSCRecoveryException;
            }
            HSCException hSCException = HSCExceptionUtils.convertCIMException(cIMException);
            throw hSCException;
        }
        object = "DLPAR: Completed activation of partition.";
        String[] stringArray = new String[]{HSCLogUtils.getUserName(null)};
        HSCLogUtils.logSystemEvent((short)2163, (String)object, stringArray, null);
    }

    public int hmcCPUMEMDLPAROp(String string, int n, HSCLPARCIMClient hSCLPARCIMClient, String string2, boolean bl) throws HSCException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        short s = 0;
        if (hSCLPARCIMClient == this) {
            s = this.getPartitionSlotId();
        } else if (hSCLPARCIMClient != null) {
            s = hSCLPARCIMClient.getPartitionSlotId();
        }
        vector.addElement(new CIMProperty(MOF_DEST_SLOT_ID, new CIMValue((Object)new UnsignedInt8(s))));
        if (string.equals(MOF_MEM_LPAR_TASK)) {
            vector.addElement(new CIMProperty(string2, new CIMValue((Object)new UnsignedInt32((long)n))));
        } else {
            vector.addElement(new CIMProperty(string2, new CIMValue((Object)new UnsignedInt8((short)n))));
        }
        if (string.equals(MOF_MEM_LPAR_TASK)) {
            vector.addElement(new CIMProperty(MOF_IS_ROLLBACK, new CIMValue((Object)new Boolean(bl), new CIMDataType(10))));
        }
        try {
            if (IDebug.enabled()) {
                System.out.println("Start calling mem/cpu CIM method");
            }
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, string, vector, vector2);
            if (IDebug.enabled()) {
                System.out.println("Finish calling mem/cpu CIM method");
            }
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
        if (vector2.size() > 0) {
            CIMProperty cIMProperty = (CIMProperty)vector2.elementAt(0);
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMProperty.getValue().getValue();
            if (unsignedInt8 == null) {
                return -1;
            }
            return unsignedInt8.shortValue();
        }
        return 0;
    }

    public Vector hmcSlotDLPAROp(Hashtable hashtable, HSCLPARCIMClient hSCLPARCIMClient) throws HSCException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        short s = 0;
        if (hSCLPARCIMClient == this) {
            s = this.getPartitionSlotId();
        } else if (hSCLPARCIMClient != null) {
            s = hSCLPARCIMClient.getPartitionSlotId();
        }
        vector.addElement(new CIMProperty(MOF_DEST_SLOT_ID, new CIMValue((Object)new UnsignedInt8(s))));
        vector.addElement(new CIMProperty(MOF_DRAWER_ID, new CIMValue(hashtable.get("IODrawerDeviceID"), new CIMDataType(29))));
        Short[] shortArray = (Short[])hashtable.get(MOF_PCI_BUS);
        Short[] shortArray2 = (Short[])hashtable.get(MOF_SLOT_ID);
        UnsignedInt8[] unsignedInt8Array = new UnsignedInt8[shortArray.length];
        UnsignedInt8[] unsignedInt8Array2 = new UnsignedInt8[shortArray2.length];
        int n = 0;
        while (n < shortArray2.length) {
            unsignedInt8Array2[n] = new UnsignedInt8(shortArray2[n].shortValue());
            unsignedInt8Array[n] = new UnsignedInt8(shortArray[n].shortValue());
            ++n;
        }
        vector.addElement(new CIMProperty(MOF_SLOT_ID, new CIMValue((Object)unsignedInt8Array2, new CIMDataType(21))));
        vector.addElement(new CIMProperty(MOF_PCI_BUS, new CIMValue((Object)unsignedInt8Array, new CIMDataType(21))));
        String[] stringArray = (String[])hashtable.get("IODrawerDeviceID");
        int n2 = 0;
        while (n2 < stringArray.length) {
            System.out.println("DrawerId[" + n2 + "]: " + stringArray[n2]);
            ++n2;
        }
        Short[] shortArray3 = (Short[])hashtable.get(MOF_SLOT_ID);
        int n3 = 0;
        while (n3 < shortArray3.length) {
            System.out.println("SlotId[" + n3 + "]: " + shortArray3[n3]);
            ++n3;
        }
        Short[] shortArray4 = (Short[])hashtable.get(MOF_PCI_BUS);
        int n4 = 0;
        while (n4 < shortArray4.length) {
            System.out.println("PCIBus[" + n4 + "]: " + shortArray4[n4]);
            ++n4;
        }
        try {
            if (IDebug.enabled()) {
                System.out.println("Start calling Slot CIM method");
            }
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_IO_LPAR_TASK, vector, vector2);
            if (IDebug.enabled()) {
                System.out.println("Finish calling Slot CIM method");
            }
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
        Object e = vector2.elementAt(0);
        Vector vector3 = null;
        vector3 = e instanceof CIMValue ? (Vector)((CIMValue)e).getValue() : (Vector)((CIMProperty)e).getValue().getValue();
        boolean[] blArray = new boolean[vector3.size()];
        String string = this.getSlotOutMessage(vector3, stringArray, shortArray3, blArray);
        if (string != null) {
            Vector<Object> vector4 = new Vector<Object>();
            vector4.addElement(string);
            vector4.addElement(blArray);
            return vector4;
        }
        return null;
    }

    public String doVTerm(short s, String string) throws HSCException {
        CIMObjectPath cIMObjectPath = null;
        CIMProperty cIMProperty = null;
        CIMProperty cIMProperty2 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        int n = 0;
        try {
            cIMProperty = new CIMProperty("Request", new CIMValue((Object)new UnsignedInt8(s)));
            cIMProperty2 = new CIMProperty("Session_Number", new CIMValue((Object)new UnsignedInt8(0)));
            vector.add(cIMProperty);
            vector.add(cIMProperty2);
            string2 = ((HSCCECClient)this.getParentObject()).getIntName();
            string3 = ((HSCCECClient)this.getParentObject()).getHostName();
            string4 = this.getIntName();
            cIMObjectPath = this.getObjectPath();
            n = Integer.parseInt((String)HscUtil.invokeCIMMethod(string3, cIMObjectPath, "VirtualTTYRequest", vector, vector2).getValue());
            if (s == 1) {
                string5 = new String("_VT_ " + string3 + " " + "9734" + " " + string4 + " " + n + " " + string4 + " _VT_");
            }
        }
        catch (Exception exception) {
            HSCLogUtils.clientLog(exception, HSCLogUtils._DLPARClassLogInfo);
            throw new HSCException(exception.getMessage());
        }
        return string5;
    }

    public int shutdownOS(Boolean bl, Boolean bl2) throws HSCException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        int n = 0;
        int n2 = 0;
        String string = null;
        String string2 = SHUTDOWN_OS_OK;
        String string3 = "";
        int n3 = 0;
        try {
            vector.add(new CIMProperty(MOF_SHUTDOWN_OS_FORCE_OPTION, new CIMValue((Object)bl, new CIMDataType(10))));
            vector.add(new CIMProperty(MOF_SHUTDOWN_OS_REBOOT_OPTION, new CIMValue((Object)bl2, new CIMDataType(10))));
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_SHUTDOWN_OS, vector, vector2);
            if (vector2.elementAt(0) instanceof CIMValue) {
                n = ((UnsignedInt32)((CIMValue)vector2.elementAt(0)).getValue()).intValue();
                n2 = ((UnsignedInt32)((CIMValue)vector2.elementAt(1)).getValue()).intValue();
                string = (String)((CIMValue)vector2.elementAt(2)).getValue();
            } else {
                n = ((UnsignedInt32)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
                n2 = ((UnsignedInt32)((CIMProperty)vector2.elementAt(1)).getValue().getValue()).intValue();
                string = (String)((CIMProperty)vector2.elementAt(2)).getValue().getValue();
            }
            if (n != 0) {
                n3 += n;
                string2 = SHUTDOWN_OS_ERROR;
                string3 = string3 + HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "RMC_LINUX_SHUTDOWN_FAILURE", "The RMC Resource Manager failed with return code {0}.\n", new String[]{Integer.toString(n)});
            }
            if (n2 != 0) {
                n3 += n;
                string2 = SHUTDOWN_OS_ERROR;
                string3 = string3 + HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "RMC_AIX_SHUTDOWN_FAILURE", "The operating system on the logical partition failed with return code {0}.\n", new String[]{Integer.toString(n2)});
            }
            this.mOutputStrHandler.handleOutputStr(string2 + "\n");
            if (string != null && !string.equals("")) {
                this.mOutputStrHandler.handleOutputStr("\t" + string);
            }
            if (string3 != null && !string3.equals("")) {
                throw new HSCException(string3);
            }
            return n3;
        }
        catch (CIMException cIMException) {
            string3 = string3 + cIMException.getMessage() + "\n";
            throw new HSCException(string3);
        }
    }

    public Hashtable getSNIInfo() throws HSCException {
        Hashtable hashtable;
        block9: {
            Object object;
            Object object2;
            hashtable = new Hashtable();
            Hashtable hashtable2 = null;
            Hashtable hashtable3 = null;
            HSCCECCIMClient hSCCECCIMClient = (HSCCECCIMClient)this.mParentObject;
            try {
                object2 = HscUtil.getCIMAttribute(this.mHostName, hSCCECCIMClient.getObjectPath(), "RuntimeCapability");
                if (object2 != null && ((Integer)(object = Integer.valueOf((String)object2.getValue())) & 0x20) == 0) {
                    return hashtable;
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
                if (IDebug.enabled()) {
                    throwable.printStackTrace();
                }
                return hashtable;
            }
            object2 = null;
            object = null;
            String string = null;
            Vector vector = null;
            int n = 0;
            try {
                Vector vector2 = hSCCECCIMClient.getSNIResources();
                Hashtable hashtable4 = hSCCECCIMClient.getSNIResourceUsage();
                CIMInstance cIMInstance = this.getCIMInstance();
                String string2 = (String)cIMInstance.getProperty("UserDefinedName").getValue().getValue();
                if (vector2 == null || vector2.size() <= 0) break block9;
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    hashtable2 = (Hashtable)enumeration.nextElement();
                    object2 = (String)hashtable2.get("DeviceID");
                    n = ((String)object2).indexOf(47);
                    if (n < 0) continue;
                    object = ((String)object2).substring(0, n);
                    vector = (Vector)hashtable4.get(object);
                    Enumeration enumeration2 = vector.elements();
                    while (enumeration2.hasMoreElements()) {
                        hashtable3 = (Hashtable)enumeration2.nextElement();
                        Enumeration enumeration3 = hashtable3.keys();
                        while (enumeration3.hasMoreElements()) {
                            string = (String)enumeration3.nextElement();
                            if (!string.equals(string2)) continue;
                            hashtable.put(object2, hashtable3.get(string));
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
                if (!IDebug.enabled()) break block9;
                throwable.printStackTrace();
            }
        }
        return hashtable;
    }

    private String getMessage(String string, String string2, Object[] objectArray) {
        String string3 = HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, string, string2, objectArray);
        this.mOutputStrHandler.handleOutputStr(string3);
        return string3;
    }

    private String getMessage(Throwable throwable) {
        String string = throwable.getMessage();
        this.mOutputStrHandler.handleOutputStr(string);
        return string;
    }

    private Hashtable slotInfoTrim(Hashtable hashtable, boolean[] blArray, boolean bl) {
        Short[] shortArray = (Short[])hashtable.get(MOF_PCI_BUS);
        Short[] shortArray2 = (Short[])hashtable.get(MOF_SLOT_ID);
        String[] stringArray = (String[])hashtable.get("SlotLocation");
        String[] stringArray2 = (String[])hashtable.get("IODrawerDeviceID");
        Vector<String> vector = new Vector<String>();
        Vector<Short> vector2 = new Vector<Short>();
        Vector<String> vector3 = new Vector<String>();
        Vector<Short> vector4 = new Vector<Short>();
        int n = 0;
        while (n < stringArray.length) {
            if (blArray[n] != bl) {
                vector3.addElement(stringArray[n]);
                vector.addElement(stringArray2[n]);
                vector4.addElement(shortArray2[n]);
                vector2.addElement(shortArray[n]);
            }
            ++n;
        }
        Hashtable<String, Object[]> hashtable2 = new Hashtable<String, Object[]>();
        int n2 = vector3.size();
        if (n2 == 0) {
            return hashtable2;
        }
        String[] stringArray3 = new String[n2];
        Short[] shortArray3 = new Short[n2];
        String[] stringArray4 = new String[n2];
        Short[] shortArray4 = new Short[n2];
        hashtable2.put(MOF_PCI_BUS, vector2.toArray(shortArray3));
        hashtable2.put("SlotLocation", vector3.toArray(stringArray4));
        hashtable2.put("IODrawerDeviceID", vector.toArray(stringArray3));
        hashtable2.put(MOF_SLOT_ID, vector4.toArray(shortArray4));
        return hashtable2;
    }

    private Hashtable slotInfoTrim(Hashtable hashtable, int n, boolean bl) {
        String[] stringArray = (String[])hashtable.get("SlotLocation");
        boolean[] blArray = new boolean[stringArray.length];
        int n2 = 0;
        while (n2 < blArray.length) {
            blArray[n2] = n2 < n;
            ++n2;
        }
        return this.slotInfoTrim(hashtable, blArray, bl);
    }

    private String getSlotOutMessage(Vector vector, String[] stringArray, Short[] shortArray, boolean[] blArray) {
        boolean bl = false;
        String string = ERR_SLOT_HMC;
        int n = 0;
        while (n < vector.size()) {
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)vector.elementAt(n);
            short s = unsignedInt8.shortValue();
            boolean bl2 = blArray[n] = s == 0;
            if (s != 0) {
                String string2 = null;
                string2 = s == 2 ? ERR_SLOT_REQUIRED : (s == 3 ? ERR_SLOT_NOT_STOPPED : (s == 4 ? ERR_SLOT_NOT_MATCH : (s == 5 ? ERR_SLOT_SAME_GROUP : (s == 6 ? ERR_SLOT_SRC_PAR : (s == 7 ? ERR_SLOT_OP_FAILED : "" + s)))));
                string = string + stringArray[n] + "/" + shortArray[n] + " " + string2 + "\n";
                bl = true;
            }
            ++n;
        }
        if (bl) {
            return string;
        }
        return null;
    }

    private CIMInstance buildProfileInParams(CIMInstance cIMInstance, Hashtable hashtable) throws HSCException {
        UnsignedInt16[] unsignedInt16Array;
        Hashtable hashtable2 = null;
        HSCCECCIMClient hSCCECCIMClient = null;
        Integer n = null;
        List list = null;
        List list2 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        Short s = null;
        String string = null;
        String string2 = null;
        Object var13_13 = null;
        String string3 = null;
        String string4 = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<UnsignedInt8> vector3 = new Vector<UnsignedInt8>();
        short s2 = -1;
        short s3 = -1;
        short s4 = -1;
        short s5 = -1;
        short s6 = -1;
        short s7 = -1;
        long l = -1L;
        long l2 = -1L;
        long l3 = -1L;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        Short s8 = new Short(0);
        String[] stringArray5 = new String[]{};
        Integer[] integerArray = new Integer[]{};
        short s9 = 1;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        string = (String)hashtable.get("Action");
        string2 = (String)hashtable.get("PartitionName");
        string4 = (String)hashtable.get("UserDefinedName");
        n = (Integer)hashtable.get("DesiredCPUCount");
        if (n != null) {
            s2 = n.shortValue();
        }
        if ((n = (Integer)hashtable.get("MinimumCPUCount")) != null) {
            s3 = n.shortValue();
        }
        if ((n = (Integer)hashtable.get("MaximumCPUCount")) != null) {
            s4 = n.shortValue();
        }
        if ((n = (Integer)hashtable.get("DesiredMemoryMB")) != null) {
            l = n.longValue();
        }
        if ((n = (Integer)hashtable.get("MinimumMemoryMB")) != null) {
            l2 = n.longValue();
        }
        if ((n = (Integer)hashtable.get("MaximumMemoryMB")) != null) {
            l3 = n.longValue();
        }
        if ((s = (Short)hashtable.get(MOF_SERVICE_AUTHORITY)) != null) {
            s7 = s;
        }
        if ((s = (Short)hashtable.get("RMOSize")) != null) {
            s9 = s;
        }
        if (IDebug.enabled) {
            System.out.println("The RMO Type is " + s9);
        }
        if ((s = (Short)hashtable.get("SFPSurveillance")) != null) {
            s6 = s;
        }
        if ((s = (Short)hashtable.get("BootMode")) != null) {
            s5 = s;
        }
        list = (List)hashtable.get("Desired_IO");
        list2 = (List)hashtable.get("Required_IO");
        hSCCECCIMClient = (HSCCECCIMClient)this.getParentObject();
        if (list != null) {
            hashtable2 = hSCCECCIMClient.convertPhyLocsToSlotDrawerIds(list);
            stringArray2 = (String[])hashtable2.get("IODrawer");
            stringArray4 = (String[])hashtable2.get("IOSlots");
        }
        if (list2 != null) {
            hashtable2 = hSCCECCIMClient.convertPhyLocsToSlotDrawerIds(list2);
            stringArray = (String[])hashtable2.get("IODrawer");
            stringArray3 = (String[])hashtable2.get("IOSlots");
        }
        if (stringArray != null && stringArray3 != null) {
            n2 = stringArray.length;
        }
        if (stringArray2 != null && stringArray4 != null) {
            n3 = stringArray2.length;
        }
        int n4 = n2 + n3;
        short s10 = 0;
        Object var46_43 = null;
        int n5 = 0;
        while (n5 < n2) {
            vector.add(n5, stringArray[n5]);
            vector2.add(n5, REQUIRED_VALUE);
            string3 = stringArray3[n5];
            s10 = Short.parseShort(string3);
            vector3.add(n5, new UnsignedInt8(s10));
            ++n5;
        }
        int n6 = n2;
        while (n6 < n4) {
            vector.add(n6, stringArray2[n6 - n2]);
            vector2.add(n6, "D");
            string3 = stringArray4[n6 - n2];
            s10 = Short.parseShort(string3);
            vector3.add(n6, new UnsignedInt8(s10));
            ++n6;
        }
        s8 = (Short)hashtable.get("SNIConfigMode");
        var9_9 = hashtable.get("SNIDeviceID");
        if (var9_9 != null) {
            stringArray5 = var9_9;
        }
        if ((var9_9 = hashtable.get("SNIWindows")) != null) {
            integerArray = var9_9;
        }
        if (stringArray5 != null && integerArray != null) {
            unsignedInt16Array = null;
            Vector<String> vector4 = new Vector<String>();
            Vector<Integer> vector5 = new Vector<Integer>();
            int n7 = 0;
            while (n7 < stringArray5.length) {
                unsignedInt16Array = new StringTokenizer(stringArray5[n7], "/");
                while (unsignedInt16Array.hasMoreTokens()) {
                    vector4.addElement(unsignedInt16Array.nextToken());
                    vector5.addElement(integerArray[n7]);
                }
                ++n7;
            }
            stringArray5 = vector4.toArray(stringArray5);
            integerArray = vector5.toArray(integerArray);
        }
        if (string.equals("createProfile")) {
            cIMInstance.setProperty("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
            cIMInstance.setProperty("PartitionName", new CIMValue((Object)string2));
            cIMInstance.setProperty("SettingID", new CIMValue((Object)"tempSID"));
        }
        cIMInstance.setProperty("DesiredCPUCount", new CIMValue((Object)new UnsignedInt8(s2)));
        cIMInstance.setProperty("MinimumCPUCount", new CIMValue((Object)new UnsignedInt8(s3)));
        cIMInstance.setProperty("MaximumCPUCount", new CIMValue((Object)new UnsignedInt8(s4)));
        cIMInstance.setProperty("DesiredMemoryMB", new CIMValue((Object)new UnsignedInt32(l)));
        cIMInstance.setProperty("MinimumMemoryMB", new CIMValue((Object)new UnsignedInt32(l2)));
        cIMInstance.setProperty("MaximumMemoryMB", new CIMValue((Object)new UnsignedInt32(l3)));
        if (vector == null && vector.size() == 0) {
            vector = new Vector();
        }
        cIMInstance.setProperty("IODrawer", new CIMValue(vector, new CIMDataType(29)));
        if (vector2 == null && vector2.size() == 0) {
            vector2 = new Vector();
        }
        cIMInstance.setProperty("IORequirement", new CIMValue(vector2, new CIMDataType(29)));
        if (vector3 == null && vector3.size() == 0) {
            vector3 = new Vector();
        }
        cIMInstance.setProperty("IOSlots", new CIMValue(vector3, new CIMDataType(21)));
        if (s8 != null) {
            cIMInstance.setProperty("SNIConfigMode", new CIMValue((Object)new UnsignedInt8(s8.shortValue()), new CIMDataType(1)));
        }
        if (stringArray5 != null) {
            cIMInstance.setProperty("SNIDeviceID", new CIMValue((Object)stringArray5, new CIMDataType(29)));
        }
        unsignedInt16Array = null;
        if (integerArray != null) {
            unsignedInt16Array = new UnsignedInt16[integerArray.length];
            int n8 = 0;
            while (n8 < integerArray.length) {
                unsignedInt16Array[n8] = new UnsignedInt16(integerArray[n8].intValue());
                ++n8;
            }
            cIMInstance.setProperty("SNIWindows", new CIMValue((Object)unsignedInt16Array, new CIMDataType(23)));
        }
        cIMInstance.setProperty("BootMode", new CIMValue((Object)new UnsignedInt8(s5)));
        cIMInstance.setProperty(MOF_SERVICE_AUTHORITY, new CIMValue((Object)new UnsignedInt8(s7)));
        cIMInstance.setProperty("RMOSize", new CIMValue((Object)new UnsignedInt8(s9)));
        cIMInstance.setProperty("SFPSurveillance", new CIMValue((Object)new UnsignedInt8(s6)));
        cIMInstance.setProperty("UserDefinedName", new CIMValue((Object)string4));
        return cIMInstance;
    }
}

